unit MAIN;

//  ,     
//       . 

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    GroupBox1: TGroupBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    Label1: TLabel;
    Label2: TLabel;
    Button1: TButton;
    Button2: TButton;
    Label3: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

type
   //  
   TPerson = class
   	fName : string; //     
   	constructor Create(name : string);
   	function Info() : string; virtual;
   end;

   //  
   TStud = class(TPerson)
   	fGr : integer; //  
   	constructor Create(name : string; gr : integer);
   	function Info() : string; override;
   end;

   //  
   TProf = class(TPerson)
   	fdep : string; //  
   	constructor Create(name:string;dep:string);
   	function Info() : string; override;
   end;

var
  Form1  : TForm1;
  List   : array[1..10] of TPerson;  //  
  LCount : integer = 0;              // -   

implementation
{$R *.DFM}

// =====================================================================
//    
//  
constructor TPerson.Create(name : string);
begin
  fName := name;
end;
//    ""
constructor TStud.Create(name : string; gr : integer);
begin
  inherited Create(name); //    
  fGr := gr;
end;
//    ""
constructor TProf.Create(name : string; dep : string);
begin
  inherited Create(name); //    
  fDep := dep;
end;
//    
function TPerson.Info() : string;
begin
  result := fname;
end;
//    
function TStud.Info() : string;
begin
    result := fname + #09 + '   ' + IntToStr(fGr);
end;
//    
function TProf.Info() : string;
begin
    result := fname +  #09 + '  : ' + fDep;
end;

// =====================================================================
//    
procedure TForm1.Button1Click(Sender: TObject);
var WInt : integer;
begin
  if LCount < High(List)
  then begin
    //    
    if Radiobutton1.Checked
    then begin
      //   ""  
      try
         WInt := StrToInt(Edit2.Text);
         LCount := LCount + 1;  //    
         //   TStud
         List[LCount] := TStud.Create(Edit1.Text,WInt);
      except
        ShowMessage ('   ');
        Exit;       //     
      end;
    end
    else begin
        //   ""  
        LCount := LCount + 1;  //    
        //   TProf
        List[LCount] := TProf.Create(Edit1.Text,Edit2.Text);
    end;
    //    
    Edit1.Text := '';
    Edit1.SetFocus;  //    
   end
   else ShowMessage('  !');
end;

//   
procedure TForm1.Button2Click(Sender: TObject);
var
  WInd : integer; // 
  WStr : string;  // 
begin
  for WInd := Low(List) to High(List) do
  begin
     if List[WInd] <> NIL
     then WStr := WStr + List[WInd].Info() + #13;
  end;
  ShowMessage('  : ' + #13 + WStr);
end;

end.
